﻿using System;
using System.Diagnostics;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.Create
{
    /// <summary>
    /// Set the Meeting Room Name Step. 
    /// </summary>
    public class SetMeetingRoomNameStep : FilterBase<VirtualMeetingRoomCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VirtualMeetingRoomCreateStateObject state)
        {
            var continueFindingNumber = true;
            string proposedName;
            var timer = Stopwatch.StartNew();
            var depth = 0;

            do
            {
                var randomDigit = RandomDigits.GetRandomDigitString(7);
                depth++;

                proposedName = $"{state.VirtualMeetingRoomPrefix}{randomDigit}";

                using (var context = new Xrm(state.OrganizationServiceProxy))
                {
                    Logger.Instance.Debug($"Progress: Beginning VMR Step. Took {timer.ElapsedMilliseconds} ms");

                    var dateHundredDaysAgo = state.AppointmentStartDate.Subtract(new TimeSpan(100, 0, 0, 0));

                    var match = context.ServiceAppointmentSet.FirstOrDefault(x =>
                        x.Id != state.AppointmentId &&
                        x.mcs_meetingroomname != null &&
                        x.ScheduledStart >= dateHundredDaysAgo &&
                        x.ScheduledStart <= state.AppointmentStartDate &&
                        x.mcs_meetingroomname == proposedName);

                    Logger.Instance.Debug($"Progress: Retrieved All VMR Appointments. Took {timer.ElapsedMilliseconds} ms");

                    if (match == null) continueFindingNumber = false;
                }
            } while (continueFindingNumber);
            
            if (string.IsNullOrEmpty(proposedName)) throw new Exception("Unable to generate VMR name");

            state.MeetingRoomName = proposedName;

            Logger.Instance.Debug($"Progress: Generated unique Meeting Room Name - {state.MeetingRoomName}. Took {timer.ElapsedMilliseconds} ms with {depth} try(s)");
            timer.Stop();
        }
    }
}